#!/usr/bin/php
<?php

require_once("config.php");

// ***************** README *****************
// Script cree par Jerome Michaux
// Date de premiere diffusion : 08/02/2017
// Version 1.2 (13/02/2017)
// Contact : contact@g-rom.info

// Ce script permet de synchroniser l'annuaire AD avec l'annuaire phpIPAM

// Changelog 1.1 (09/02/2017) :
// - Suppression des comptes MySQL orphelins

// Changelog 1.2 (13/02/1017) :
// - Prise en charge PSTN


// ***************** PARAMETRES *****************

//Groupe AD des admins
$admingroupdn = "CN=ACCESS-IPAM-Admins,OU=Security Groups,OU=MONLAB,DC=monlab,DC=local";

//Groupe AD des membres autorisés a acceder au menu PSTN
$pstngroupdn = "CN=ACCESS-IPAM-PSTN,OU=Security Groups,OU=MONLAB,DC=monlab,DC=local";
$pstnprivlvl = 1; //1 = RO ; 2 = RW ; 3 = RW Admin

//Activation du mode debug (affichage terminal, a desactiver en production)
$debug = true;


// ***************** CODE *****************

function debug($str) {
		global $debug;
		if($debug) {
				$STDERR = fopen('php://stderr', 'w+');
				fwrite($STDERR, $str . "\r\n");
				fclose($STDERR);
		}
}

debug("Debut de traitement");

//Connexion à la base de données
$bdd = mysqli_connect($db['host'], $db['user'], $db['pass'], $db['name'], $db['port']);
if($bdd = mysqli_connect($db['host'], $db['user'], $db['pass'], $db['name'], $db['port'])) {

	mysqli_set_charset($bdd, "utf8");

	//On recupere la config AD/LDAP de phpipam
	$req_ldap_config = mysqli_query($bdd, 'SELECT * FROM usersAuthMethod WHERE type="AD" LIMIT 0, 1');
	$res_ldap_config = mysqli_fetch_assoc($req_ldap_config);
	$ldap = json_decode($res_ldap_config['params'], true);
	$ldap_srv = explode(";", $ldap['domain_controllers']);
	$ldap_id = $res_ldap_config['id'];

	//Connexion à tous les annuaires de la liste (test sur plusieurs annuaires, le premier qui répond a gagné
	for($boucle_ldap=0; $boucle_ldap < count($ldap_srv); $boucle_ldap++) {
		if($ds = ldap_connect($ldap_srv[$boucle_ldap])) {

			debug("Connecte a " . $ldap_srv[$boucle_ldap]);
		
			$boucle_ldap = count($ldap_srv); //Permet de sortir de la boucle en fin de traitement
			
			ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
			ldap_set_option($ds, LDAP_OPT_REFERRALS, 0);
			
			// Bind sur le user
			if(ldap_bind($ds, $ldap['adminUsername'], $ldap['adminPassword'])) {
				
				debug("Bind OK avec " . $ldap['adminUsername']);
				
				//Array de groupes vides
				$allgroups = array();
				
				//On recherche les groupes AD
				$srgroup=ldap_search($ds, $ldap['base_dn'], "(objectclass=group)");
				
				//On vérifie ensuite pour chaque groupe s'il existe dans la base
				$req_user_groups = mysqli_prepare($bdd, 'SELECT g_id FROM userGroups WHERE g_name = ?');
				
				$group = ldap_get_entries($ds, $srgroup);
				for ($boucle_group = 0; $boucle_group<$group["count"]; $boucle_group++) {
					mysqli_stmt_bind_param($req_user_groups, "s", $group[$boucle_group]['cn'][0]);
					mysqli_stmt_execute($req_user_groups);
					mysqli_stmt_bind_result($req_user_groups, $gid);
					while(mysqli_stmt_fetch($req_user_groups)) {
						$allgroups[$gid] = $group[$boucle_group]['distinguishedname'][0];
					}
				}
				
				//On recherche les utilisateurs dans l'AD
				$sruser=ldap_search($ds, $ldap['base_dn'], "(samAccountType=805306368)");
				
				//Requete preparee pour interroger la base SQL
				$req_users = mysqli_prepare($bdd, 'SELECT * FROM users WHERE username = ? AND authMethod = ?');
				
				$user = ldap_get_entries($ds, $sruser);
				
				$usersToEdit = array();
				$usersToDelete = array();
				
				for($boucle_user = 0; $boucle_user<$user["count"]; $boucle_user++) {
					
					//On verifie si le user appartient a un des groupes référencés sur IPAM
					$ipam_grp = array();
					$grole = "User";
					$gpstn = 0;
					$buser = $user[$boucle_user];
					if(isset($buser['memberof']['count'])) {
						for($boucle_usergrp = 0; $boucle_usergrp < $buser['memberof']['count']; $boucle_usergrp++) {
							$getgid = array_search($buser['memberof'][$boucle_usergrp], $allgroups);

							if($buser['memberof'][$boucle_usergrp] == $pstngroupdn) {
								debug("L'utilisateur " . $buser['samaccountname'][0] . " a acces au menu PSTN avec le niveau " . $pstnprivlvl);
								$gpstn = $pstnprivlvl;
							}
							
							if($getgid !== false) {
								$ipam_grp[$getgid] = $getgid;
								if($allgroups[$getgid] == $admingroupdn) {
									debug("L'utilisateur " . $buser['samaccountname'][0] . " a le privilege administrateur");
									$grole = "Administrator";
									$gpstn = 3;
								}
							}
						}
					}
					
					//Traitement si le user fait au moins parti d'un groupe IPAM
					if(count($ipam_grp) > 0) {
						
						//On ajoute le user à une base de comptes
						array_push($usersToEdit, $buser['samaccountname'][0]);
												
						//On vérifie si le user existe déjà en base sql
						mysqli_stmt_bind_param($req_users, "si", $buser['samaccountname'][0], $ldap_id);
						mysqli_stmt_execute($req_users);
						mysqli_stmt_store_result($req_users);
						
						if(mysqli_stmt_num_rows($req_users)>0) {
							//Le user existe déjà, il faudra faire un update
							debug("L'utilisateur " . $buser['samaccountname'][0] . " existe deja en base IPAM --> mise a jour");
							
							$req_users_update = mysqli_prepare($bdd, 'UPDATE users SET role = ?, groups = ?, real_name = ?, email = ?, pstn = ? WHERE username = ?');
							mysqli_stmt_bind_param($req_users_update, "ssssis", $grole, json_encode($ipam_grp, JSON_FORCE_OBJECT), $buser['displayname'][0], $buser['mail'][0], $gpstn, $buser['samaccountname'][0]);
							if(mysqli_stmt_execute($req_users_update)) {
								debug(" --> Mise a jour OK");
							}
							else {
								debug(" --> Erreur Mise a jour");
							}
							
						}
						else {
							//Le user n'existe pas, il faudra le creer
							debug("L'utilisateur " . $buser['samaccountname'][0] . " n'existe pas en base IPAM --> creation");
							
							$req_users_insert = mysqli_prepare($bdd, 'INSERT INTO users (username, authMethod, password, groups, role, real_name, email, domainUser, widgets, lang, mailNotify, mailChangelog, passChange, compressOverride, hideFreeRange, menuType, pstn) VALUES (?, ?, "", ?, ?, ?, ?, 30, ?, 9, "No", "No", "No", "default", 0, "Dynamic", ?)');
							$setWidget = "statistics;favourite_subnets;changelog;top10_hosts_v4";
							mysqli_stmt_bind_param($req_users_insert, "sisssssi", $buser['samaccountname'][0], $ldap_id, json_encode($ipam_grp, JSON_FORCE_OBJECT), $grole, $buser['displayname'][0], $buser['mail'][0], $setWidget, $gpstn);
							if(mysqli_stmt_execute($req_users_insert)) {
								debug(" --> Creation OK");
							}
							else {
								debug(" --> Erreur Creation");
							}
						}
					}
					else {
						debug("L'utilisateur " . $buser['samaccountname'][0] . " n'est reference dans aucun groupe IPAM");
					}
				}
				
				//Recherche des comptes orphelins
				debug("Recherche des comptes MySQL orphelins de l'AD");
				$req_users_cleanup = mysqli_prepare($bdd, 'SELECT username FROM users WHERE authMethod = ?');

				mysqli_stmt_bind_param($req_users_cleanup, "i", $ldap_id);
				mysqli_stmt_execute($req_users_cleanup);
				mysqli_stmt_bind_result($req_users_cleanup, $myuser);
				while(mysqli_stmt_fetch($req_users_cleanup)) {
					if(array_search($myuser, $usersToEdit) === false) {
						debug("L'utilisateur " . $user[$boucle_user]['samaccountname'][0] . " n'existe pas dans l'AD --> suppression");
						array_push($usersToDelete, $myuser);
					}
				}
				
				//Suppression des comptes
				debug("Suppression des comptes orphelins et des comptes sans groupe d'appartenance IPAM");
				$req_users_delete = mysqli_prepare($bdd, 'DELETE FROM users WHERE username = ? AND authMethod = ?');
				foreach($usersToDelete as $aUserToDelete) {					
					mysqli_stmt_bind_param($req_users_delete, "si", $aUserToDelete, $ldap_id);
					if(mysqli_stmt_execute($req_users_delete)) {
						debug(" --> Suppression " . $aUserToDelete . " OK");
					}
					else {
						debug(" --> Erreur Suppression" . $aUserToDelete);
					}				
				}
			}
		}
		else {
			debug("Connexion a " . $ldap_srv[$boucle_ldap] . " impossible !");
		}
	}

	if($ds) {		
		debug("Fermeture connexion LDAP");
		ldap_close($ds);
	}
	else {
		debug("Aucune connexion LDAP disponible");
	}
	
	//Fermeture connexion MySQL
	mysqli_close($bdd);
	debug("Fermeture connexion MySQL");
}
else {
	debug("Aucune connexion MySQL disponible");
}

debug("Fin de traitement");

?>