#!/usr/bin/php
<?php

// ***************** README *****************
// Script cree par Jerome Michaux
// Date de premiere diffusion : 26/08/2015
// Version 1.1 (20/02/2017)
// Contact : contact@g-rom.info

// Ce script permet de rcuprer en SNMP des valeurs de temperature issues de sondes DS18B20

// Changelog 1.1 (20/02/2017) :
// - Correction bug si sonde non dtecte


// ***************** PARAMETRES *****************

// OID racine
$place = ".1.3.6.1.4.1.2021.42";

// Liste des sondes  poller
$sensors[1]['id'] = "28-031563c81bff";
$sensors[1]['description'] = "Sonde bureau";
$sensors[2]['id'] = "28-031563f8b9ff";
$sensors[2]['description'] = "Sonde salle info baie 1";
$sensors[3]['id'] = "28-031561c42cff";
$sensors[3]['description'] = "Sonde salle info baie 6";


// ***************** CODE *****************

if(!isset($argv[1])) exit(1); //absence parametre (-n ==> next request // -g ==> request)
if(!isset($argv[2])) exit(1); //absence oid

function readTemperature($sensor) {
	if(file_exists("/sys/bus/w1/devices/" . $sensor . "/w1_slave")) {
		try {
			$temperature = file_get_contents("/sys/bus/w1/devices/" . $sensor . "/w1_slave");
			$pos = strrpos($temperature, "t=") + 2;
			$temperature = substr($temperature, $pos, 5);
			$temperature = round($temperature/1000, 0);
			return $temperature;
		}
		catch (Exception $e) {
			return "-42";
		}
	}
	else {
		return "-42";
	}
}

function buildSnmpOIDTopology($place, $sensors) {

	$topo = array();
	
	foreach ($sensors as $idsensor => $sensor) {
		
		//Valeur temperature
		$oid = $place . "." . $idsensor . ".0";
		$value = $oid . "\ninteger\n##TEMPERATURE_" . $sensor['id'] . "##\n";
		$topo[$oid] = $value;
		
		//Valeur description
		$oid = $place . "." . $idsensor . ".1";
		$value = $oid . "\nstring\n" . $sensor['description'] . "\n";
		$toreturn2[$oid] = $value;
		$topo[$oid] = $value;
		
		//Valeur id
		$oid = $place . "." . $idsensor . ".2";
		$value = $oid . "\nstring\n" . $sensor['id'] . "\n";
		$toreturn3[$oid] = $value;
		$topo[$oid] = $value;
		
	}
	
	ksort($topo);	
	return $topo;

}

function findNextOID($oid, $topo) {
	
	//On insere l'OID dans la topologie
	if(!isset($topo[$oid])) {
		$topo[$oid] = "FINGERPRINT";
	}
	
	//On trie selon les cls
	ksort($topo);
	
	//Puis on parcourt les cls pour retourner celle qui suit celle qu'on a marqu
	$breakpoint = false;
	foreach($topo as $key => $value) {
		if($breakpoint) return $key;
		if($key == $oid) $breakpoint = true;
	}
	if($oid == $key) return false;
	return $key;
}

function findOID($oid, $topo) {
	
	if(array_key_exists ($oid, $topo)) {
		return $oid;
	}
	return false;	
}

function replaceFingerprintByTemp($str) {
	
	global $sensors;
	//recherche premier watermark
	$debut = strpos($str, "##TEMPERATURE_");
	if($debut) {
		$debut;
		$fin = strpos($str, "##", $debut + 1);
		//on extrait l'id de la sonde
		$idsensor = substr($str, $debut + 14, $fin - ($debut + 14));
		$temp = readTemperature($idsensor);
		$str = str_replace("##TEMPERATURE_" . $idsensor . "##", $temp, $str);
	}
	return $str;
}

// **** Dbut du main ****

//OID request
$req = $argv[2];

$topo = buildSnmpOIDTopology($place, $sensors);
$oid = false;

if($argv[1] == "-n") {
	$oid = findNextOID($req, $topo);
}
elseif($argv[1] == "-g") {
	$oid = findOID($req, $topo);
}

/*rappel : format des OID
premiere valeur = numro de sonde (en partant de 1)
deuxieme valeur 
 0 ==> la valeur en integer
 1 ==> la description en string
 2 ==> l'ID 1wire
 */

if($oid) {
	//on remplace le marqueur par la temperature
	echo replaceFingerprintByTemp($topo[$oid]);
}
else {
	echo "\n";
	exit(0);
}

exit(0);

?>

