#!/usr/bin/php
<?php

// ***************** README *****************
// Script cree par Jerome Michaux
// Date de premiere diffusion : 27/01/2017
// Version 1.0
// Script libre d'utilisation. La diffusion de ce code doit se faire exclusivement au travers de mon blog : www.g-rom.info
// Contact : contact@g-rom.info


// ***************** PARAMETRAGE GLOBAL *****************

//Activation du mode debug (affichage terminal, a desactiver en production)
$debug = true;


// ***************** PARAMETRAGE DOMOTICZ *****************

//URL de Domoticz (NE PAS METTRE de '/' a la fin")
$urldomo = "http://127.0.0.1:8080";

//IDX stockant le compteur
$idxdomo = 14;


// ***************** PARAMETRAGE COMPTEUR *****************

//IP de IPX800
$ipipx = "192.168.18.4";

//Port HTTP de IPX800
$portipx = 80;

//Nombre d'impulsions par kwh (depend des specificites du compteur a impulsion)
$nbimpkwh = 2000;

//Nombre minimum d'impulsions requis pour que la mesure soit suffisament precise
$miniimp = 100;

//Temps maximum avant de forcer la maj (en secondes) (permet de quand meme actualiser en cas de tres faible consommation
$maxtime = 600;

//Numero de compteur sur IPX800 (entre "1" et "8")
$nbcounter = 1;

//Puissance administrative du disjoncteur principal, en watts
//Pour le calcul, prendre le calibre en amperes multipli par 230V
//Pour les puristes, je sais il manque le cos phi, mais le but est d'avoir un point de repere pour voir si le comptage est coherent :-)
$maxpower = 6000;


// ***************** CODE A EXECUTER (ne pas toucher) *****************

function debug($str) {
	global $debug;
	if($debug) {
		$STDERR = fopen('php://stderr', 'w+');
		fwrite($STDERR, $str . "\r\n");
		fclose($STDERR);
	}
}

$ratio = ($nbimpkwh / 3600) / 1000;

//recuperation de la derniere update du compteur
$domoticz_elec_counter = file_get_contents($urldomo . "/json.htm?type=devices&rid=" . $idxdomo);
$domoticz_elec_counter = json_decode($domoticz_elec_counter, true);
$domoticz_elec_data = $domoticz_elec_counter['result'][0]['Data'];
$domoticz_elec_data = explode(" ", $domoticz_elec_data, 2);
$domoticz_elec_data = $domoticz_elec_data[0];
debug("Nb de kwh cumule en base = " . $domoticz_elec_data);
$lastupdate = $domoticz_elec_counter['result'][0]['LastUpdate'];
debug("Derniere MAJ = " . $lastupdate);
$lastupdate = strtotime($lastupdate);
debug("Derniere MAJ (timestamp) = " . $lastupdate);

//On en profite pour recuperer l'heure courante (Ne pas recuperer le timestamp pour eviter les pb de fuseaux horaires)
$actualtime = strtotime($domoticz_elec_counter['ServerTime']);

//calcul de la difference en secondes
$time = $actualtime - $lastupdate;

if($time < 0) {
	debug("Erreur: l'heure du serveur est inferieure a l'heure memorisee dans domoticz. FIN D'EXECUTION");
	exit(0);
}

//recuperation du compteur sur l'ipx
$ipx_elec_counter = file_get_contents("http://" . $ipipx . ":" . $portipx . "/api/xdevices.json?cmd=40");
$ipx_elec_counter = json_decode($ipx_elec_counter, true);
$counter = $ipx_elec_counter['C' . $nbcounter];
debug("Compteur IPX = " . $counter);

if($counter > $miniimp || $time > $maxtime) {

	//calcul nb de watts instantanés
	$watt = ($counter / $time) / $ratio;
	$watt = round($watt, 0);
	debug("watts = " . $watt);

	//on verifie que le nombre de watts ne dépasse pas la puissance administrative (tolerance de 20%)
	if($watt > ($maxpower * 1.2)) {
		$watt = 0;
		$counter = 0;
		debug("Depassement puissance administrative, reinitialisation de 'watt' a 0");
	}
	
	//calcul du nombre de wh cumul
	$wh_old = $domoticz_elec_data * 1000;
	$wh = $wh_old + ($counter / ($nbimpkwh / 1000)) ;
	$wh = round($wh, 0);
	debug("wh cumule actuel = " . $wh_old);
	debug("wh cumule cible = " . $wh);
	
	//mise à jour de domoticz
	$update_domoticz = file_get_contents($urldomo . "/json.htm?type=command&param=udevice&idx=" . $idxdomo . "&nvalue=0&svalue=" . $watt . ";" . $wh);
	$update_domoticz = json_decode($update_domoticz, true);
	
	if($update_domoticz['status'] == "OK") {
		//remise a zero compteur IPX
		debug("Update domoticz ok");
		try {
			file_get_contents("http://" . $ipipx . ":" . $portipx . "/protect/assignio/counter" . (($nbcounter + 1) / 2)  . ".htm?num=" . ($nbcounter - 1) . "&counter=0");
			debug("RAZ compteur de l'ipx ok");
		}
		catch (Exception $e) {
			debug("Erreur lors de la raz du compteur de l'ipx");
		}
	}
	else {
		debug("Erreur lors de la maj de domoticz");
	}
}
else {
	debug("Minimum impulsions non atteint");
}

?>
