# Milight Multi-Bridge Emulator
# Version 0.1
# Cree le 29/07/2016
# Jerome Michaux (contact _at_ g-rom.info)
# Usage et diffusion libre sous reserve de citation de l'origine des sources
# www.g-rom.info

from threading import Thread, RLock, Event
from time import sleep
import socket
import binascii

class MilightDriver(Thread):

    def __init__(self, ip, udpport, delay):
        Thread.__init__(self)
        self.cmd = []
        self.delay = delay
        self.ip = ip
        self.udpport = udpport
        self.mutex = RLock()
        self.event = Event()

    def push_command(self, command, delay):
        with self.mutex:
            self.cmd.append([command, delay])
        self.event.set()

    def run(self):
        '''
        Thread permettant de dépiler les commandes contenues dans l'attribut "cmd"
        Un déclencheur "event" permet de bloquer la boucle tant qu'un objet n'a pas été empilé dans "cmd"
        Un mutex RLock "mutex" permet de gérer les accès en écriture à l'objet "cmd"
        En d'autres termes il est impossible de pusher une nouvelle commande tant que la boucle est en train de poper
        '''

        try:
            udpsocket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
            udpsocket.connect((self.ip, self.udpport))
            print("Driver start... // TEST")
            print("Send commands to", self.ip, "udp port", self.udpport)

        except:
            print("Erreur de creation du socket")

        while True:
            #On attend le déclencheur
            self.event.wait()
            # print("Tour de boucle du Driver")
            #On bloque le mutex
            with self.mutex:
                if len(self.cmd) > 0:
                    imax = len(self.cmd) - 1
                    i = 0
                    newcmd = []
                    while i <= imax:
                        if self.cmd[i][1] > self.delay:
                            #On décrémente le délais
                            self.cmd[i][1] -= self.delay
                        else:
                            #On pop et on l'ajoute a la liste d'ordres
                            newcmd.append(self.cmd.pop(i))
                            imax -= 1
                        i += 1
                    for str_rf in newcmd:
                        print("Received RF Command on Driver : " + str_rf[0])
                        #to_send = binascii.unhexlify(str_rf[0].replace(" ", ""))
                        #to_send = binascii.unhexlify(str_rf[0].replace(" ", "") + "40")
                        to_send = binascii.unhexlify((str_rf[0].replace(" ", "") + "40").encode("ascii"))
                        udpsocket.send(to_send)
                        sleep(self.delay)
                        #udpsocket.send(binascii.unhexlify(str_rf[0].replace(" ", "") + "40"))
                        #sleep(self.delay)
                else:
                    self.event.clear()
