# Milight Multi-Bridge Emulator
# Version 0.1
# Cree le 29/07/2016
# Jerome Michaux (contact _at_ g-rom.info)
# Usage et diffusion libre sous reserve de citation de l'origine des sources
# www.g-rom.info

from threading import Thread
import socket
import binascii


# TODO : CREER DES PROPERTIES...

class MilightBridge(Thread):
    def __init__(self, ip, udpport, remote):
        Thread.__init__(self)
        self.ip = ip
        self.udpport = udpport
        self.remote = remote[0]

    def UDPInterpreter(self, data):
        data = binascii.hexlify(data).decode().upper()
        if len(data) == 4:
            data += "55"
        print("Received on port", self.udpport, ":", data)

        ###### RGBW Lights #####

        # Light on / off
        if data == "420055":
            print("Light On Group All")
            self.remote.group = 0
            self.remote.power_on()
            self.remote.push_rf()
        elif data == "410055":
            print("Light Off Group All")
            self.remote.group = 0
            self.remote.power_off()
            self.remote.push_rf()
        elif data == "450055":
            print("Light On Group 1")
            self.remote.group = 1
            self.remote.power_on()
            self.remote.push_rf()
        elif data == "460055":
            print("Light Off Group 1")
            self.remote.group = 1
            self.remote.power_off()
            self.remote.push_rf()
        elif data == "470055":
            print("Light On Group 2")
            self.remote.group = 2
            self.remote.power_on()
            self.remote.push_rf()
        elif data == "480055":
            print("Light Off Group 2")
            self.remote.group = 2
            self.remote.power_off()
            self.remote.push_rf()
        elif data == "490055":
            print("Light On Group 3")
            self.remote.group = 3
            self.remote.power_on()
            self.remote.push_rf()
        elif data == "4A0055":
            print("Light Off Group 3")
            self.remote.group = 3
            self.remote.power_off()
            self.remote.push_rf()
        elif data == "4B0055":
            print("Light On Group 4")
            self.remote.group = 4
            self.remote.power_on()
            self.remote.push_rf()
        elif data == "4C0055":
            print("Light Off Group 4")
            self.remote.group = 4
            self.remote.power_off()
            self.remote.push_rf()

        # White mode
        elif data == "C20055":
            print("White Mode Group All")
            self.remote.group = 0
            self.remote.white_mode()
            self.remote.push_rf(100)
        elif data == "C50055":
            print("White Mode Group 1")
            self.remote.group = 1
            self.remote.white_mode()
            self.remote.push_rf()
        elif data == "C70055":
            print("White Mode Group 2")
            self.remote.group = 2
            self.remote.white_mode()
            self.remote.push_rf()
        elif data == "C90055":
            print("White Mode Group 3")
            self.remote.group = 3
            self.remote.white_mode()
            self.remote.push_rf()
        elif data == "CB0055":
            print("White Mode Group 4")
            self.remote.group = 4
            self.remote.white_mode()
            self.remote.push_rf()

        # Brightness
        elif data[0:2] == "4E":
            br = int(data[2:4], 16)
            br = br - 2
            self.remote.brightness = br
            print("Set Brightness : " + str(br))
            self.remote.push_rf()

        # Color
        elif data[0:2] == "40":
            cl = int(data[2:4], 16)
            self.remote.color = cl
            print("Set Color : " + self.remote.color_name + " (" + str(cl) + ")")
            self.remote.push_rf()

        # Disco mode
        elif data == "4D0055":
            print("Disco mode Selection - NOT WORKING")
            self.remote.disco_mode()
            self.remote.push_rf()

        elif data == "430055":
            print("Disco mode Speed Down - NOT WORKING")
            self.remote.command = 12
            self.remote.push_rf()

        elif data == "440055":
            print("Disco mode Speed Up - NOT WORKING")
            self.remote.command = 11
            self.remote.push_rf()

        # Unknow....
        else:
            print("ERROR: Unknow Command")

    def run(self):
        try:
            udpsocket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
            udpsocket.bind((self.ip, self.udpport))
            print("Listen on", self.ip, "udp port", self.udpport)

        except:
            print("Socket creation error")

        while True:
            try:
                data, addr = udpsocket.recvfrom(3)

            except:
                print("ERROR: Received an oversized UDP packet")

            self.UDPInterpreter(data)

