# Milight Multi-Bridge Emulator
# Version 0.1
# Cree le 29/07/2016
# Jerome Michaux (contact _at_ g-rom.info)
# Usage et diffusion libre sous reserve de citation de l'origine des sources
# www.g-rom.info

from MilightBridge import MilightBridge
from MilightDriver import MilightDriver
from MilightRemote import MilightRemoteRGBW

#Configuration fixe
NbOfRemotes = 7
StartRemoteId = 0xD242
StartPort = 8842

# Etapes de creation du processus
# 1) on ouvre le driver
# 2) on créé les télécommandes, auxquelles on passe la reference du driver (la télécommande écrira ses commandes dans le driver)
#    ==> Une remote c'est un tuple contenant une télécommande RGBW, une télécommande CWW et une télécommande RGB
# 3) on créé les bridges, auxquelles on passe la reference de la télécommande associée (ca permettra d'écrire les nouvelles valeurs)
# 4) on créé l'interface HTTP, auxquelles on passe la référence de toutes les télécommandes

def InitRemotes(NbOfRemotes, StartRemoteId, Driver):
    Remotes = []
    while NbOfRemotes > 0:
        RemoteRGBW = MilightRemoteRGBW(StartRemoteId, Driver)
        #RemoteCWW = MilightRemoteRGBW(StartRemoteId, Driver)
        #RemoteRGB = MilightRemoteRGBW(StartRemoteId, Driver)
        #RemoteTuple = (RemoteRGBW, RemoteCWW, RemoteRGB)
		RemoteTuple = (RemoteRGBW)
        Remotes.append(RemoteTuple)
        StartRemoteId += 1
        NbOfRemotes -= 1
    return Remotes

def InitBridges(StartPort, Remotes):
    Bridges = []
    for Rem in Remotes:
        Br = MilightBridge("0.0.0.0", StartPort, Rem)
        Br.start()
        Bridges.append(Br)
        StartPort += 1
    return Bridges

# Creation et demarrage du driver
drv = MilightDriver("127.0.0.1", 8899, 0.005)
drv.start()

# Creation des télécommandes
remotes = InitRemotes(NbOfRemotes, StartRemoteId, drv)

# Creation des bridges
bridges = InitBridges(StartPort, remotes)
